/************************************************************************
 * \file: trace_static_lib.c
 *
 * \version: $Id: trace_static_lib.c,v 1.2 2012/05/28 10:30:39 jayanth.mc Exp $
 *
 * This file implements static library interface for Trace. Trace based
 * applications shall individually link to this file.
 *
 * \component: Gen2 Trace
 *
 * \author B. Das         Bhaskar.Das(o)in.bosch.com
 *         Sakthivelu S.  Sakthivelu.S(o)in.bosch.com
 *
 * \copyright: (c) 2003 - 2009 ADIT
 *
 ***********************************************************************/

#include <stdlib.h>
#include <string.h>
#include "trace_atrace.h"
#include "trace_base.h"

IMPORT TRACE_start_fp TRACE_init_fp;

/* Pointer to Class and Level info per module */
static TRACE_class_cnfg* g_c_cnfg = NULL;

/**
 * Initialize Trace static library
 *
 * \param None
 *
 * \return E_OK if initialization is successfull
 *              else error returned by concrete implementation
 */
LOCAL ER TRACE_STATLIB_init(void);
LOCAL ER TRACE_STATLIB_init(void)
{
  TRACE_cfg_data setup = {&g_c_cnfg};
  ER             rc    = E_OK;

  rc = TRACE_get_sh_cnfg(&setup);
  return rc;
}

/**
 * UnInitialize Trace static library
 *
 * \param None
 *
 * \return None
 */
EXPORT void TRACE_STATLIB_uninit(void)
{
  g_c_cnfg = NULL ;
}

/**
 * External interface for checking class/level status
 *
 * \parm  trClass        Trace class
 *        enLevel        Trace level
 * return \li BOOL       TR_ENABLED_CLASS_TRC, if enabled for TTFis
 *                       TR_ENABLED_CLASS_PXY, if enabled for Proxy
 *                       TR_ENABLED_CLASS_PMM, if enabled for PMM
 *                       TR_ENABLED_CLASS_ALL, if enabled for all above
 *                       TR_ENABLED_CLASS_NONE, otherwise
 */
EXPORT BOOL TR_core_bIsClassSelected(U16 trClass, TR_tenTraceLevel enLevel)
{
  TRACE_clas_ena_stat status   = TR_ENABLED_CLASS_NONE;
  U8                  compid   = (U8)TR_COMPID(trClass) ;
  U8                  clasid   = (U8)TR_CLASID(trClass) ;
  TRACE_lvl           lvl; 
  BOOL                result   = FALSE;

  memset(&lvl, 0, sizeof(lvl) );
  /*SWGIII-3621: TRACE static constructor for init() dangerous */
  result = TRACE_init_fp();
  if(result >= E_OK)
  {
    if((TR_LEVEL_FATAL == enLevel) ||
      (TR_CLASS_POSTMORTEM == (TR_tenTraceClass)trClass))
    {
      /* Fatal messages and PMM messages are always traced */
      status = TR_ENABLED_CLASS_ALL;
    }
    else
    {
      /* Get the shared mem ptr for the first time */
      if(g_c_cnfg == NULL)
      {
        (void)TRACE_STATLIB_init();
      }

      /* Enabled for TTFis */
      if((g_c_cnfg != NULL) &&
        (g_c_cnfg->comp[compid].max_clas > 0) &&
        (clasid <= g_c_cnfg->comp[compid].max_clas))
      {
        lvl = g_c_cnfg->comp[compid].lvl[clasid];
      }

      status = (enLevel <= (TR_tenTraceLevel)lvl.trc_lvl) ?
            TR_ENABLED_CLASS_TRC : TR_ENABLED_CLASS_NONE;

      status = (TRACE_clas_ena_stat)((U32)status |
                             (U32)((enLevel <= (TR_tenTraceLevel)lvl.pxy_lvl) ?
                              TR_ENABLED_CLASS_PXY : TR_ENABLED_CLASS_NONE));
    }
    result = (TR_ENABLED_CLASS_NONE == status) ? FALSE : (S32)status;
  }
  else
  {
      result = FALSE;
  }
  return result;
}

/**
 * This function is added for backward compatibility
 * External interface for checking class/level status for Proxy
 *
 * \parm  enClass     Trace class
 *        enLevel     Trace level
 * return \li BOOL    TRUE, if enabled
 *                    FALSE, otherwise
 */
EXPORT BOOL TR_proxy_bIsClassSelected(TR_tenTraceClass enClass,
                                  TR_tenTraceLevel enLevel)
{
  TRACE_clas_ena_stat status   = TR_ENABLED_CLASS_NONE;
  U8                  compid   = (U8)TR_COMPID((U16)enClass) ;
  U8                  clasid   = (U8)TR_CLASID((U16)enClass) ;
  TRACE_lvl           lvl;
  BOOL                result   = FALSE;

  memset(&lvl, 0, sizeof(lvl) );
  if((TR_LEVEL_FATAL == enLevel) || (TR_CLASS_POSTMORTEM == enClass))
  {
    /* Fatal messages and PMM messages are always traced */
    status = TR_ENABLED_CLASS_ALL;
  }
  else
  {
    /* Get the shared mem ptr for the first time */
    if(g_c_cnfg == NULL)
    {
      (void)TRACE_STATLIB_init();
    }

    /* Enabled for Proxy */
    if((g_c_cnfg != NULL) && (clasid <= g_c_cnfg->comp[compid].max_clas))
    {
      lvl = g_c_cnfg->comp[compid].lvl[clasid];
    }

    status = (enLevel <= (TR_tenTraceLevel)lvl.pxy_lvl) ?
               TR_ENABLED_CLASS_PXY : TR_ENABLED_CLASS_NONE;
  }
  result = (TR_ENABLED_CLASS_PXY == status) ? TRUE : FALSE;
  return result;
}
